Ext.data.JsonP.sol_common_ObjectFormatter_StatisticSord({"tagname":"class","name":"sol.common.ObjectFormatter.StatisticSord","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ObjectFormatter.js","href":"lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord"}],"author":[{"tagname":"author","name":"Michael Weiler, ELO Digital Office GmbH","email":null},{"tagname":"author","name":"Nils Mosbach, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"elojc":true,"eloas":true,"aliases":{},"alternateClassNames":[],"extends":"sol.common.ObjectFormatter.BaseSord","mixins":[],"requires":[],"uses":[],"members":[{"name":"allFormBlobFields","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-allFormBlobFields","meta":{}},{"name":"allMapFields","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-allMapFields","meta":{}},{"name":"allObjKeys","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-allObjKeys","meta":{}},{"name":"descMaxLen","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-descMaxLen","meta":{}},{"name":"feedActions","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-feedActions","meta":{"private":true}},{"name":"formBlobPrefix","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-formBlobPrefix","meta":{}},{"name":"formBlobs","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-formBlobs","meta":{}},{"name":"hiddenObjKeyPrefix","tagname":"cfg","owner":"sol.common.ObjectFormatter.StatisticSord","id":"cfg-hiddenObjKeyPrefix","meta":{}},{"name":"hiddenObjKeys","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-hiddenObjKeys","meta":{}},{"name":"list","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-list","meta":{"private":true}},{"name":"mapKeys","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-mapKeys","meta":{}},{"name":"maximum","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-maximum","meta":{"private":true}},{"name":"objKeyPrefix","tagname":"cfg","owner":"sol.common.ObjectFormatter.StatisticSord","id":"cfg-objKeyPrefix","meta":{}},{"name":"objKeys","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-objKeys","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sordKeys","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-sordKeys","meta":{}},{"name":"wfMapKeys","tagname":"cfg","owner":"sol.common.ObjectFormatter.BaseSord","id":"cfg-wfMapKeys","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"actionTypeMappings","tagname":"property","owner":"sol.common.ObjectFormatter.BaseSord","id":"property-actionTypeMappings","meta":{"private":true}},{"name":"flatObjStructure","tagname":"property","owner":"sol.common.ObjectFormatter.StatisticSord","id":"property-flatObjStructure","meta":{}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mapKeyPrefix","tagname":"property","owner":"sol.common.ObjectFormatter.StatisticSord","id":"property-mapKeyPrefix","meta":{"private":true}},{"name":"pilcrow","tagname":"property","owner":"sol.common.ObjectFormatter.BaseSord","id":"property-pilcrow","meta":{"private":true}},{"name":"requiredProperties","tagname":"property","owner":"sol.common.ObjectFormatter.StatisticSord","id":"property-requiredProperties","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addObjKeyJson","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-addObjKeyJson","meta":{"private":true}},{"name":"addSordTypeKind","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-addSordTypeKind","meta":{}},{"name":"applyFeedActions","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyFeedActions","meta":{"private":true}},{"name":"applyFormBlobData","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyFormBlobData","meta":{"private":true}},{"name":"applyFormBlobKey","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyFormBlobKey","meta":{"private":true}},{"name":"applyMapData","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyMapData","meta":{"private":true}},{"name":"applyMapKey","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyMapKey","meta":{"private":true}},{"name":"applyObjKey","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyObjKey","meta":{"private":true}},{"name":"applyObjKeys","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyObjKeys","meta":{"private":true}},{"name":"applySordKeys","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applySordKeys","meta":{"private":true}},{"name":"applyWfMapData","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyWfMapData","meta":{"private":true}},{"name":"applyWfMapKey","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-applyWfMapKey","meta":{"private":true}},{"name":"build","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-build","meta":{}},{"name":"buildCacheMaskObjKeys","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-buildCacheMaskObjKeys","meta":{"private":true}},{"name":"buildJson","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-buildJson","meta":{}},{"name":"getFeedActionsJson","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-getFeedActionsJson","meta":{"private":true}},{"name":"getSordTypeKind","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-getSordTypeKind","meta":{}},{"name":"initialiseFormattedSord","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-initialiseFormattedSord","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-initialize","meta":{"private":true}},{"name":"isValidObjKey","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-isValidObjKey","meta":{"private":true}},{"name":"normalizeFeedActionTypes","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-normalizeFeedActionTypes","meta":{"private":true}},{"name":"shouldAddSordTypeKind","tagname":"method","owner":"sol.common.ObjectFormatter.BaseSord","id":"method-shouldAddSordTypeKind","meta":{}}],"code_type":"ext_define","id":"class-sol.common.ObjectFormatter.StatisticSord","short_doc":"Represents limited compact data of an ELO object for dashboards. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ObjectFormatter.BaseSord"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='docClass'>sol.common.ObjectFormatter.BaseSord</a><div class='subclass '><strong>sol.common.ObjectFormatter.StatisticSord</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord' target='_blank'>lib_sol.common.ObjectFormatter.js</a></div></pre><div class='doc-contents'><p>Represents limited compact data of an ELO object for dashboards.</p>\n\n<p>If working with large amounts of data it is mandatory to define the properties required for the data analys in order\nto reduce the amount of data loaded from the client. IndexServer Sord-Objects contain a lot of information that might\nnot be required for the analysis. <a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a> allows defining the sord keys, objKeys,\n... information that is required.</p>\n\n<p>For more information on configuration properties please refer to <a href=\"#!/api/sol.common.ObjectFormatter.BaseSord\" rel=\"sol.common.ObjectFormatter.BaseSord\" class=\"docClass\">sol.common.ObjectFormatter.BaseSord</a>.</p>\n\n<p>This functionality is used by sol.common.ix.functions.ChildrenDataCollector while collecting data for dashboard apps\ndeveloped in angular js.</p>\n\n<pre><code>var data = <a href=\"#!/api/sol.common.ObjectFormatter-method-format\" rel=\"sol.common.ObjectFormatter-method-format\" class=\"docClass\">sol.common.ObjectFormatter.format</a>({\n  sord: {\n    formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a>',\n    // instance of de.elo.ix.client.Sord\n    data: sord,\n    config: {\n      sordKeys: ['id', 'maskName', 'name', 'IDateIso', 'XDateIso'],\n      objKeys: ['VENDOR_NAME', 'INVOICE_DATE', 'INVOICE_CASH_DISCOUNT_AMOUNT']\n    }\n  }\n});\n</code></pre>\n\n<p>The transformed object results as followed.</p>\n\n<pre><code>data = {\n  \"id\": \"7572\",\n  \"maskName\": \"Incoming invoice\",\n  \"name\": \"Invoice 0000\",\n  \"IDateIso\": \"20150720142400\",\n  \"XDateIso\": \"\",\n  \"O_VENDOR_NAME\": \"Weiler KG\",\n  \"O_INVOICE_DATE\": \"20150601162415\",\n  \"O_INVOICE_CASH_DISCOUNT_AMOUNT\": 554,\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-allFormBlobFields' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-allFormBlobFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-allFormBlobFields' class='name expandable'>allFormBlobFields</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Set to true if all Form-Blob fields should be included. ...</div><div class='long'><p>Set to true if all Form-Blob fields should be included. formBlobs[] configuration is ignored in this case.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-allMapFields' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-allMapFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-allMapFields' class='name expandable'>allMapFields</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Set to true if all map fields should be included. ...</div><div class='long'><p>Set to true if all map fields should be included. mapKeys[] configuration is ignored in this case.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-allObjKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-allObjKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-allObjKeys' class='name expandable'>allObjKeys</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Set to true if all objKeys should be included. ...</div><div class='long'><p>Set to true if all objKeys should be included. objKeys[] configuration is ignored in this case.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-descMaxLen' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-descMaxLen' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-descMaxLen' class='name expandable'>descMaxLen</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Maximum length of the sord description</p>\n</div><div class='long'><p>Maximum length of the sord description</p>\n</div></div></div><div id='cfg-feedActions' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-feedActions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-feedActions' class='name expandable'>feedActions</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>This is an experimental feature. ...</div><div class='long'><p>This is an experimental feature. Don't rely on its existance.\nSet to true if feed actions of this sord should be collected as well.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-formBlobPrefix' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-formBlobPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-formBlobPrefix' class='name expandable'>formBlobPrefix</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Defines a prefix for formBlob field names. ...</div><div class='long'><p>Defines a prefix for formBlob field names.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='cfg-formBlobs' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-formBlobs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-formBlobs' class='name expandable'>formBlobs</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Form-Blob field names of the Form-Blob-fields that should be included.</p>\n</div><div class='long'><p>Form-Blob field names of the Form-Blob-fields that should be included.</p>\n</div></div></div><div id='cfg-hiddenObjKeyPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.StatisticSord'>sol.common.ObjectFormatter.StatisticSord</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord-cfg-hiddenObjKeyPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.StatisticSord-cfg-hiddenObjKeyPrefix' class='name expandable'>hiddenObjKeyPrefix</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Defines a prefix for hidden objKey field names. ...</div><div class='long'><p>Defines a prefix for hidden objKey field names.</p>\n<p>Defaults to: <code>&quot;H_&quot;</code></p><p>Overrides: <a href=\"#!/api/sol.common.ObjectFormatter.BaseSord-cfg-hiddenObjKeyPrefix\" rel=\"sol.common.ObjectFormatter.BaseSord-cfg-hiddenObjKeyPrefix\" class=\"docClass\">sol.common.ObjectFormatter.BaseSord.hiddenObjKeyPrefix</a></p></div></div></div><div id='cfg-hiddenObjKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-hiddenObjKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-hiddenObjKeys' class='name expandable'>hiddenObjKeys</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Key names of the hidden object keys that should be included.</p>\n</div><div class='long'><p>Key names of the hidden object keys that should be included.</p>\n</div></div></div><div id='cfg-list' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-list' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-list' class='name expandable'>list</a> : de.elo.ix.client.feed.EActionType[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>of feed action types\nThis is an experimental feature. ...</div><div class='long'><p>of feed action types\nThis is an experimental feature. Don't rely on its existance.\nDefine a list of Feed Action types that should be returned.</p>\n</div></div></div><div id='cfg-mapKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-mapKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-mapKeys' class='name expandable'>mapKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Map field names of the map fields that should be included.</p>\n</div><div class='long'><p>Map field names of the map fields that should be included.</p>\n</div></div></div><div id='cfg-maximum' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-maximum' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-maximum' class='name expandable'>maximum</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>amount of actions that are read\nThis is an experimental feature. ...</div><div class='long'><p>amount of actions that are read\nThis is an experimental feature. Don't rely on its existance.\nThe amount of feed actions that is returned by FindFirstActions.</p>\n</div></div></div><div id='cfg-objKeyPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.StatisticSord'>sol.common.ObjectFormatter.StatisticSord</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord-cfg-objKeyPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.StatisticSord-cfg-objKeyPrefix' class='name expandable'>objKeyPrefix</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Defines a prefix for mapKey field names. ...</div><div class='long'><p>Defines a prefix for mapKey field names.</p>\n<p>Defaults to: <code>&quot;O_&quot;</code></p><p>Overrides: <a href=\"#!/api/sol.common.ObjectFormatter.BaseSord-cfg-objKeyPrefix\" rel=\"sol.common.ObjectFormatter.BaseSord-cfg-objKeyPrefix\" class=\"docClass\">sol.common.ObjectFormatter.BaseSord.objKeyPrefix</a></p></div></div></div><div id='cfg-objKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-objKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-objKeys' class='name expandable'>objKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Key names of the object keys that should be included. ...</div><div class='long'><p>Key names of the object keys that should be included.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-sordKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-sordKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-sordKeys' class='name expandable'>sordKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Names of the properties that should be included. ...</div><div class='long'><p>Names of the properties that should be included.\nThe ID and the mask name are included by default.</p>\n<p>Defaults to: <code>[&quot;guid&quot;, &quot;id&quot;, &quot;maskName&quot;]</code></p></div></div></div><div id='cfg-wfMapKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-cfg-wfMapKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-cfg-wfMapKeys' class='name expandable'>wfMapKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Map field names of the workflow map fields that should be included.</p>\n</div><div class='long'><p>Map field names of the workflow map fields that should be included.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-actionTypeMappings' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-property-actionTypeMappings' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-property-actionTypeMappings' class='name expandable'>actionTypeMappings</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-flatObjStructure' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.StatisticSord'>sol.common.ObjectFormatter.StatisticSord</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord-property-flatObjStructure' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.StatisticSord-property-flatObjStructure' class='name expandable'>flatObjStructure</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Use a flat object structure. ...</div><div class='long'><p>Use a flat object structure. If true, objKeyPrefix and mapKeyPrefix must be set in order to prevent overriding sord keys.</p>\n\n<p>Default. flatObjStructure = false, objKeyPrefix \"\"</p>\n\n<pre><code>{\n  name: \"my invoice\",\n  objKeys: {\n    INVOICE_NUMBER: \"1234#2\"\n  }\n}\n</code></pre>\n\n<p>Flat structure with objKeyPrefix \"O_\"</p>\n\n<pre><code>{\n  name: \"my invoice\",\n  O_INVOICE_NUMBER: \"1234#2\"\n}\n</code></pre>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href=\"#!/api/sol.common.ObjectFormatter.BaseSord-property-flatObjStructure\" rel=\"sol.common.ObjectFormatter.BaseSord-property-flatObjStructure\" class=\"docClass\">sol.common.ObjectFormatter.BaseSord.flatObjStructure</a></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mapKeyPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.StatisticSord'>sol.common.ObjectFormatter.StatisticSord</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord-property-mapKeyPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.StatisticSord-property-mapKeyPrefix' class='name expandable'>mapKeyPrefix</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;M_&quot;</code></p></div></div></div><div id='property-pilcrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-property-pilcrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-property-pilcrow' class='name expandable'>pilcrow</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\u00b6&quot;</code></p></div></div></div><div id='property-requiredProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.StatisticSord'>sol.common.ObjectFormatter.StatisticSord</span><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-StatisticSord-property-requiredProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.StatisticSord-property-requiredProperties' class='name expandable'>requiredProperties</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;sord&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addObjKeyJson' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-addObjKeyJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-addObjKeyJson' class='name expandable'>addObjKeyJson</a>( <span class='pre'>mask, params, formattedSord, addedObjKeys, objKeyPrefix, objKey</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mask</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>formattedSord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>addedObjKeys</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>objKeyPrefix</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>objKey</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-addSordTypeKind' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-addSordTypeKind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-addSordTypeKind' class='name expandable'>addSordTypeKind</a>( <span class='pre'>formattedSord, sord</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>formattedSord</span> : String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyFeedActions' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyFeedActions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyFeedActions' class='name expandable'>applyFeedActions</a>( <span class='pre'>toObj, sord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyFormBlobData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyFormBlobData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyFormBlobData' class='name expandable'>applyFormBlobData</a>( <span class='pre'>toObj, objId, flowId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyFormBlobKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyFormBlobKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyFormBlobKey' class='name expandable'>applyFormBlobKey</a>( <span class='pre'>toObj, key, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyMapData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyMapData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyMapData' class='name expandable'>applyMapData</a>( <span class='pre'>toObj, sord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyMapKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyMapKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyMapKey' class='name expandable'>applyMapKey</a>( <span class='pre'>toObj, key, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyObjKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyObjKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyObjKey' class='name expandable'>applyObjKey</a>( <span class='pre'>toObj, prefix, key, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>prefix</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyObjKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyObjKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyObjKeys' class='name expandable'>applyObjKeys</a>( <span class='pre'>toObj, maskName, objKeys</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>objKeys</span> : de.elo.ix.client.ObjKey[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applySordKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applySordKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applySordKeys' class='name expandable'>applySordKeys</a>( <span class='pre'>toObj, sord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyWfMapData' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyWfMapData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyWfMapData' class='name expandable'>applyWfMapData</a>( <span class='pre'>toObj, sord, flowId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyWfMapKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-applyWfMapKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-applyWfMapKey' class='name expandable'>applyWfMapKey</a>( <span class='pre'>toObj, key, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>toObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-build' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-build' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-build' class='name expandable'>build</a>( <span class='pre'>originalSord</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Builds the base representation of the ELO object. ...</div><div class='long'><p>Builds the base representation of the ELO object. This function is called by <a href=\"#!/api/sol.common.ObjectFormatter-method-format\" rel=\"sol.common.ObjectFormatter-method-format\" class=\"docClass\">sol.common.ObjectFormatter.format</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>originalSord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>formattedSord</p>\n</div></li></ul></div></div></div><div id='method-buildCacheMaskObjKeys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-buildCacheMaskObjKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-buildCacheMaskObjKeys' class='name expandable'>buildCacheMaskObjKeys</a>( <span class='pre'>maskName, objKeys</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds a cache for required objkeys. ...</div><div class='long'><p>Builds a cache for required objkeys. That allows reducing iteration times if thousands of sords are formatted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>objKeys</span> : de.elo.ix.client.ObjKey[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buildJson' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-buildJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-buildJson' class='name expandable'>buildJson</a>( <span class='pre'>originalSord, [mask], [params]</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Build JSON Data Structure. ...</div><div class='long'><p>Build JSON Data Structure. This function should only be used by the ELO Business Solutions team,\nsince API calls might change due to performance improvements!</p>\n\n<p>This function was designed to reduce processing times if huge amounts of data are collected by services.\nCreation of objects and properties is more than 50 times slower than building the json result with a string buffer.</p>\n\n<p>Due to performance reasons, no map data is collected.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>originalSord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Index Server Sord object</p>\n</div></li><li><span class='pre'>mask</span> : Object (optional)<div class='sub-desc'><p>Mask object created by e.g. Children data collector. Pass if</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>dataAsString</span> : String[] (optional)<div class='sub-desc'><p>Contains the names of the fields, for which all values (not just the first) should be returned as pilcrow separated string</p>\n</div></li><li><span class='pre'>dataAsArray</span> : String[] (optional)<div class='sub-desc'><p>Contains the names of the fields, for which all values (not just the first) should be returned as an array</p>\n</div></li><li><span class='pre'>addSordTypeKind</span> : boolean (optional)<div class='sub-desc'><p>if set to true adds sord type kind (e.g. \"REPOSITORY\", \"FOLDER\", \"DOCUMENT\") to formattedSord</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFeedActionsJson' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-getFeedActionsJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-getFeedActionsJson' class='name expandable'>getFeedActionsJson</a>( <span class='pre'>guid</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Reads the list of all actions for a given post. ...</div><div class='long'><p>Reads the list of all actions for a given post.</p>\n\n<p>This is an experimental feature. Don't rely on its existence.\nThis feature should be used with care since this leads to performance issues if used within large datasets.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>guid</span> : String<div class='sub-desc'><p>GUID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>json array that contains all actions pre formatted as json.</p>\n</div></li></ul></div></div></div><div id='method-getSordTypeKind' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-getSordTypeKind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-getSordTypeKind' class='name expandable'>getSordTypeKind</a>( <span class='pre'>id</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialiseFormattedSord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-initialiseFormattedSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-initialiseFormattedSord' class='name expandable'>initialiseFormattedSord</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>initial formattedSord</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-isValidObjKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-isValidObjKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-isValidObjKey' class='name expandable'>isValidObjKey</a>( <span class='pre'>sordObjKey</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>checks if objKey should be applied to the formatted object. ...</div><div class='long'><p>checks if objKey should be applied to the formatted object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sordObjKey</span> : de.elo.ix.client.ObjKey<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-normalizeFeedActionTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-normalizeFeedActionTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-normalizeFeedActionTypes' class='name expandable'>normalizeFeedActionTypes</a>( <span class='pre'>feedActionTypes</span> ) : de.elo.ix.client.feed.EActionType[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>If feed action types are defined as strings a mapping to EActionType is required. ...</div><div class='long'><p>If feed action types are defined as strings a mapping to EActionType is required.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>feedActionTypes</span> : String[]|de.elo.ix.client.feed.EActionType[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.feed.EActionType[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-shouldAddSordTypeKind' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ObjectFormatter.BaseSord' rel='sol.common.ObjectFormatter.BaseSord' class='defined-in docClass'>sol.common.ObjectFormatter.BaseSord</a><br/><a href='source/lib_sol.common.ObjectFormatter.html#sol-common-ObjectFormatter-BaseSord-method-shouldAddSordTypeKind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.BaseSord-method-shouldAddSordTypeKind' class='name expandable'>shouldAddSordTypeKind</a>( <span class='pre'>params</span> ) : boolean<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>boolean</span><div class='sub-desc'><p>should set sord type kind</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true}});